﻿//////////////////////////////////////////////
// DecodedData.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkGraphics
#include "../../Dll/DllDefines.h"

#include "DecodedBufferData.h"
#include "DecodedEntityData.h"
#include "DecodedMaterialData.h"
#include "DecodedMeshData.h"
#include "DecodedNodeData.h"
#include "DecodedSkeletonData.h"
#include "DecodedTextureData.h"

// nkMemory
#include <NilkinsMemory/Containers/BufferCast.h>

/// Structs ----------------------------------

namespace nkGraphics
{
	struct DLL_GRAPHICS_EXPORT DecodedData final
	{
		// Attributes
		nkMemory::BufferCast<DecodedEntityData> _entityData ;
		nkMemory::BufferCast<DecodedMaterialData> _materialData ;
		nkMemory::BufferCast<DecodedMeshData> _meshData ;
		nkMemory::BufferCast<DecodedNodeData> _nodeData ;
		nkMemory::BufferCast<DecodedTextureData> _textureData ;
		nkMemory::BufferCast<DecodedSkeletonData> _skeletonData ;
		nkMemory::BufferCast<DecodedBufferData> _buffers ;
	} ;
}